; 01 Try DI primary vec. bx=4 bp=8, si stays 100h (or secondary vec).

NPLANES equ 9

org 100h        ; assume al=0 bx=0 sp=di=-2 si=0100h bp=09??h; last 16 bytes of PSP = 0
   ; dw -16     ; F0FF40C2: lock inc word [bx+si-0x3e]
   db 0x84,0xC2 ;=test dl,al
PN equ $-4*5    ; dd 0.0, -1.0, /*0.0*/  ; fallthrough
RO equ $-4*3    ; dd 0.0, 0.0, -66.1
I:mov word[byte PN+4+2 + si-100h],0xBF80

;Video mode + palette: 4 bits orange * 4 bits blue. Uses default index 0 (black).
BIG equ $-1
  pusha
  mov al,13h
P:int 10h       ; set video mode | set palette index: bx=i dh=R ch=G cl=B

;  inc bx
;  mov al,bl
;  aam 16        ; ax = ....rrrr....bbbb
;BIG equ $-1
;  imul dx,ax,4
;  mov ax,1010h
;  mov cx,dx
;  add ch,cl
;  shr ch,1      ; ch=G = (R+B)/2
;  jnz P         ; dx=cx=0 bx=100h ax=1010h
  mov dx,3c8h  ; gray
  xor ax,ax
Q:mov cl,12
P2:out dx,al
  loop P2
  mov dl,0c9h
  inc ax
  cmp al,64
  jne Q

  popa

  dec di        ; di = pixel address = -3

M:mov dx,0xA000-10-20-20-4;  ; visible pixels are A0000..AF9FF: want X=0 Y=0 in the center of the screen
  mov es,dx     ; dx:bx=YX:XX = es:0     must be neighbors after PUSHA

GEN_GEM:
  pusha
  mov cx,NPLANES
  mov ax,GEM_PLANES-0x100
PL:

  fld1
  cmp cl,NPLANES
  jne Z8
  fldz
  fxch st1
  fldz
  jmp Z1
Z8:
  test cl,4
  jnz Z4
  fchs
Z4:fld st0
  test cl,2
  jnz Z2
  fchs
Z2:fld st0
  test cl,1
  jnz Z1
  fchs
Z1:
  call NORMALIZE
  xor bx,bx

  mov di,2
RR:
  fxch st2
  call STORE
  fild word[bx-6]     ;|T
  fidiv word[C100+di] ;|T/100         ;|T/16
  call ROTATE         ;|y X,Z=R(x,z)  ;|X YY,ZZ=r(y,Z)
  dec di
  dec di
  jz RR

  xchg ax,bp
  call STORE
  xchg ax,bp
  add ax,12
  loop PL
  popa


X:   ;cx=T di=adr_pixel(init=0) bp=09?? si=0100 ah=0   ; cf=0
  inc dx
X2:
  fninit        ; adr:     -18 -16 -14 -12 -10  -8  -6  -4  -2
  pusha         ; stack:    di  si  bp  sp  bx  dx  cx  ax   0
  xor bx,bx     ; s16:  pixadr 100 9??  -2  ..X..Y  T (result)

  fild word[PD + si-100h] ; p.d

  fild word[byte BIG + si-100h] ; Z=27408
  fild word[bx-8]  ; Y
  fild word[bx-9]  ; X   |rD.xyz p.d

  mov dx,RO-0x100

  call NORMALIZE
  call STORE

  call GEM_OUTER    ;|ro[dx] rd[bp] --> cf=1_if_hit di=address_of_hit_facet   ; clobbers ax,bx,cx
  mov [-4],di       ;pushed ax
  
  jnc NO_GEM_HIT
  ;jmp NO_GEM_HIT
  popa
  jmp SK

NO_GEM_HIT:
  fld1
  call LOAD_SCALE   ;|rd.xyz
PD equ $+1 ;-18
  mov bx,PN-0x100;=sp?
  call PLANE        ;|t       ; V=rd (normalized); cf=front? bx=PN-0x100=-18
  ftst
  fnstsw ax
  sahf              ; cf=0 if hit
  call LOAD_SCALE   ;|t*rd.x t*rd.y t*rd.z

  fstp st1          ; h = {ro + rd*t}; we need only x and z (+ no need to add ro)
  fistp word[bp+si] ;V = s16(h.x)
  fiadd word[bx+18-6]
  fistp word[bx+18-4]  ; pushed_ax = s16(h.z + T)
  popa
  jb  S
  xor al,[bp+si]
  ;and al,8
  shr al,4
S:salc
; db 0xA9 ; skip 2 bytes (=test ax,NN)
;S:mov al,0
SK:
  stosb
  add bx,0xCCCD ;dx:bx = YXX += 0000CCCD
  jnc X2
  jnz X   ;do 65536 iterations

  inc cx  ; T++
  in al,60h
  dec al
  jnz M
 ;ret     ; fallthrough

;LOAD:
;  fld1
;  jmp LOAD_SCALE

NORMALIZE:  ; { a.x a.y a.z } --> { n.x n.y n.z } a[bp](unnormalized) bx=bp
  mov bx,bp
  call STORE_DOT    ;|a*a   ; [bp]=a (unnormalized)
  fsqrt
  fld1
  fdivrp st1        ;|rsqrt(a*a)        ...    will be: |rd.x rd.y rd.z
LOAD_SCALE: ; { k } a[bp] --> { k*x k*y k*z }
  fld dword[bp+si+4]
  fmul st1           ;|ky k
LOAD_SCALE_XZ:
  fld dword[bp+si+8]
  fmul st2
  fxch st2           ;|k ky kz
  fmul dword[bp+si]  ;|kx ky kz
  ret

STORE:
  call STORE_DOT
  fstp st0
  ret

STORE_DOT: ; { a.x a.y a.z } --> a[bp]
  fstp dword[bp+si]
  fstp dword[bp+si+4]
  fstp dword[bp+si+8]

DOT:  ; a[bp] b[bx] --> { a.x*b.x+a.y*b.y+a.z*b.z }
  fld dword[bp+si]
  fmul dword[bx+si]
  fld dword[bp+si+4]
  fmul dword[bx+si+4]
  faddp
  fld dword[bp+si+8]
  fmul dword[bx+si+8]
  faddp
  ret

PLANE:  ; { rd.x rd.y rd.z pd } pn[bx] ro[dx] --> { t } cf=front? rd[bp]; clobbers ax
  pusha
  call STORE_DOT  ;|D=pn*rd pd     ;  V=rd
  mov bp,dx
  call DOT        ;|pn*ro D pd
  fsubp st2,st0   ;|D pd-pn*ro
  ftst
  fnstsw ax
  sahf           ; cf=1 if we're in front of the plane
  fdivp st1,st0   ;|t=N/D
  popa
  ret


;BACKGROUND:
;
;
;SCENE:  ; { rd.x rd.y rd.z } ro[ax] --> color[bp+4]
;  call GEM        ; cf=1 if hit; ax=face, [bp+8]=d|p[face],
;  jnc BACKGROUND
;  fld [IOR]


;  v3 hitpos;
;  int face = ray_gem_outer(r, &hitpos);
;  if (no hit) {
;    return ray_background(r);
;  }
;  else {
;    float R = fresnel(ior, -(r.d|p[face].n));
;    ray rr{hitpos, reflect(r.d, p[face].n)};
;    float color = R * ray_background(rr);
;    if (R < 1) {
;      ray rt{hitpos, refract(r.d, p[face].n, 1.f/ior)};
;      color += (1-R) * ray_gem_inner(rt, face);
;    }
;    return color;
;  }

GEM_OUTER: ; ro[dx] rd[bp] --> cf=1_if_hit dx=address_of_hit_facet   ; clobbers ax,bx,cx,dx
  fild dword[si]  ;|tfront=0 tback=huge
  fldz
  mov cx,NPLANES
  mov bx,GEM_PLANES-0x100
G:push si
  cmp cx,NPLANES
  jne GEM_PLANE_NZ
  inc si
  inc si
GEM_PLANE_NZ:
  fild word[C16 + si-100h]  ;|pd tf tb
  pop si
  fld1
  call LOAD_SCALE       ;|rd.x rd.y rd.z pd tf tb
  call PLANE            ;|t tf tb|    cf=front? rd[bp]
  jnc GBACK
GFRONT:
  fcom st0,st1
  fnstsw ax
  sahf
  jbe GNEXT         ;if t>tf { tf=t; di=hit_address = current; }
  fst st1
  mov di,bx
  jmp GNEXT
GBACK:
  fcom st0,st2
  fnstsw ax
  sahf
  jae GNEXT        ;if t<tf { tb=t; }
  fst st2
GNEXT:
  fstp st0
  fcom
  fnstsw ax
  sahf              ;if tf>=fb { no_hit: cf=0; early return } else { cf=1 }
  jae GEXIT
  lea bx,[bx+12] ; don't set flags
  loop G
GEXIT:              ;[di+si] = facehit
  fcompp
  ret

ROTATE: ; { angle } a[bp] --> { y R(x,z) }
  fsincos            ;| c s
ROTATE_CS ; { c s } a[bp] --> { y R(x,z) }
  call LOAD_SCALE_XZ ;| sx c sz
  call LOAD_SCALE_XZ ;| cx sx cz sz
  fsubp st3,st0      ;| sx cz sz-cx
  faddp              ;| sx+cz sz-cx
  fld dword[bp+si+4] ;| y sx+cz sz-cx
  ret

C100 dw 100
C16 dw 16
C8 dw 8

;int ray_gem_outer(ray const& r, v3* hitpos) {
;  float tfront=0, tback=INFf; int face=0;
;  for (int ip=0; ip<LEN(p); ip++) {
;    hit h = ray_plane(r, p[ip]);
;    if (h.front) { if (h.t>tfront) { tfront=h.t; face=ip; } }
;    else         { if (h.t<tback) { tback=h.t; } }
;  }
;  if (tfront<tback) {  // hit!
;    *hitpos = r.o + r.d*tfront;
;    return face;
;  }
;  else return -1;
;}

;float ray_gem_inner(ray& r, int face_excluded) {
;  if (depth>depth_max) return ray_background(r);
;  depth++;
;  float t=INFf; int face=0;
;  for (int ip=0; ip<LEN(p); ip++) if (ip != face_excluded) {
;    hit h = ray_plane(r, p[ip]);
;    if (h.t>0 && h.t<t) { t=h.t; face=ip; }
;  }
;
;  v3 hitpos = r.o + r.d*t;
;  float R = fresnel(1.f/ior, r.d|p[face].n);
;  ray rr{hitpos, reflect(r.d, -p[face].n)};
;  float color = R * ray_gem_inner(rr, face);
;  if (R < 1) {
;    ray rt{hitpos, refract(r.d, -p[face].n, ior)};
;    color += (1-R) * ray_background(rt);
;  }
;  depth--;
;  return color * exp(-t * absorptivity_gem);
;}


GEM_PLANES:
;    ;  nx    ny    nz
;  dd  1.0,  0.0,  0.0
;  dd -1.0,  0.0,  0.0
;  dd  0.0,  1.0,  0.0
;  dd  0.0, -1.0,  0.0
;  dd  0.0,  0.0,  1.0
;  dd  0.0,  0.0, -1.0


;GEM: nx ny nz  d
;  db  1, 1, 2, 8   ; scale: s = 1/sqrt6
;  db -1, 1, 2, 8
;  db  1,-1, 2, 8
;  db -1,-1, 2, 8
;  db  1, 1,-1, 8   ; scale: 2*s = 1/sqrt3
;  db -1, 1,-1, 8
;  db  1,-1,-1, 8
;  db -1,-1,-1, 8
;  db  0, 0, 1, 4   ; scale: 1
